k6 v0.27.1 is a minor release with a few bugfixes and almost no functional changes compared to v0.27.0.

The biggest fix was resolving a panic (and some `k6 login` errors) when k6 was ran through git bash / Mintty on Windows ([#1559](https://github.com/loadimpact/k6/issues/1559)).

k6 will now work in those terminals, however, if you're using [git bash](https://gitforwindows.org/) or [Mintty](https://mintty.github.io/) as your terminal on Windows, you might not get the best user experience out of k6. Consider using a different terminal like [Windows Terminal](https://www.microsoft.com/en-us/p/windows-terminal/9n0dx20hk701), PowerShell or [Cmder](https://cmder.net/). Alternatively, to [work around](https://github.com/mintty/mintty/wiki/Tips#inputoutput-interaction-with-alien-programs) the issues with the incompatible terminals, you can try running k6 through [`winpty`](https://github.com/rprichard/winpty), which should already be preinstalled in your git bash environment: `winpty k6 run script.js`.

If you're using the Windows Subsystem for Linux (WSL), you are probably going to get better experience by using the official Linux k6 binary or .deb package. For all other cases of running k6 on Windows, the normal k6 Windows binary / `.msi` package should work well.

### Other minor fixes and changes:

- The Go version that k6 is compiled with was updated to 1.14.6, to incorporate the [latest Go fixes](https://github.com/golang/go/issues?q=milestone%3AGo1.14.6+label%3ACherryPickApproved) ([#1563](https://github.com/loadimpact/k6/pull/1563)).
- If the [`throw` option](https://k6.io/docs/using-k6/options#throw) is enabled, warnings for failed HTTP requests will no longer be logged to the console ([#1199](https://github.com/loadimpact/k6/issues/1199)).
- Metric sample packets sent to the cloud with `k6 run --out cloud` can now be sent in parallel via the new `K6_CLOUD_METRIC_PUSH_CONCURRENCY` option, with a default value of `1` ([#1569](https://github.com/loadimpact/k6/pull/1569)).
- The `gracefulRampDown` VU requirement calculations for the `ramping-vus` executor were greatly optimized for large test runs ([#1567](https://github.com/loadimpact/k6/pull/1567)).
- Fixed a rare bug where `dropped_iterations` wouldn't be emitted by the `per-vu-iterations` executor on time due to a race ([#1357](https://github.com/loadimpact/k6/issues/1357)).
- Metrics, including checks, from `setup()` and `teardown()`, were not correctly shown in local k6 runs ([#949](https://github.com/loadimpact/k6/issues/949)).
